#ifndef IRRX_H
#define	IRRX_H

#include <xc.h> // include processor files - each processor file is guarded.  
#include "portbits.h"

#define IRRX_PIN c2

//these are counts in 32us chunks
//4500us=140.6 nominal
#define IR_START_MIN 135
#define IR_START_MAX 146
//562.5us=17.6 nominal
#define IR_0_MIN 12
#define IR_0_MAX 23
//1687.5us=52.7 nominal
#define IR_1_MIN 47
#define IR_1_MAX 58
//2250us=70.3 nominal
#define IR_RPT_MIN 65
#define IR_RPT_MAX 76
#define IR_TIMEOUT 255

//#define CHECKBIT(n,b,m) if((irbuf[n]>=IR_1_MIN)&&(irbuf[n]<=IR_1_MAX)){rawIRpkt[b]=rawIRpkt[b]|m;}else if((irbuf[n]<IR_0_MIN)||(irbuf[n]>IR_0_MAX)){IRerror=1;}
#define CHECKBIT(n,b,m) if(irbits[n]==0xFF){IRerror=1;}else{if(irbits[n]){rawIRpkt[b]=rawIRpkt[b]|m;}}

extern char IRstate;
extern volatile char ir_t;
extern volatile char irbuf[];
extern volatile char irbufptr;
extern volatile char IRready;       //a packet is ready to be read
extern volatile char IRrpt;         //a repeat has been received
extern char IRadd;                  //address
extern char IRcode;                 //code
extern char rawIRpkt[4];            //for receiving
extern char IRerror;                //validation
extern char bitMasks[];

void IRRXinit(void);
char getIRrpt(void);

#endif	/* IRRX_H */

